

function highlight(){


    const listOfElements = document.querySelectorAll("*");
    console.log(listOfElements);
    console.log("hallo");

    detectedWordsOnThisPage = 0;
    
    for (let elementNumber = 0; elementNumber < listOfElements.length; elementNumber++) {
    let tag = listOfElements[elementNumber];

    console.log(elementNumber, tag);

    if (tag && tag.nodeType === Node.ELEMENT_NODE) { // Überprüfen, ob es ein gültiges Element ist
        const hasChildren = tag.children.length > 0;
        const elementText = tag.textContent ? tag.textContent.trim() : "";
        const hasText = elementText.length > 0;

        // Wir bearbeiten nur Elemente, die keinen Nachwuchs haben und Text enthalten
        // Warum? Weil sonst innere Tags (wie <b>, <i>) überschrieben und deren Formatierung verloren gehen würden.
        if (!hasChildren && hasText) {
            const targetWord = "hass"; // Das Wort, das unterstrichen werden soll

            // Den Text des Elements in einzelne Wörter aufteilen
            // Mithilfe eines Regulären Ausdrucks, um auch Satzzeichen am Wortende zu berücksichtigen
            const words = elementText.split(/(\s+)/); // Splittet nach Leerzeichen, behält diese aber als separate Einträge bei

            let newHTMLContent = '';

            for (let i = 0; i < words.length; i++) {
                const word = words[i];
                
                // Prüfen, ob das aktuelle "Wort" wirklich ein Wort ist (nicht nur Leerzeichen)
                if (word.trim().length === 0) {
                    newHTMLContent += word; // Leerzeichen einfach wieder hinzufügen
                    continue;
                }

                // Regulären Ausdruck verwenden, um Satzzeichen zu entfernen und nur das reine Wort zu erhalten
                const cleanWord = word.replace(/[^a-zA-ZäöüÄÖÜß0-9]/g, ''); // Entfernt alle Nicht-Buchstaben/Zahlen

                // Bedingung: Ist das bereinigte Wort unser Zielwort (Groß-/Kleinschreibung ignorieren)?
                if (cleanWord.toLowerCase() === targetWord.toLowerCase()) {
                    // Wenn ja, umschließe das ursprüngliche Wort (inkl. Satzzeichen) mit dem Unterstreichungs-Span
                    newHTMLContent += `<span style="text-decoration: underline; text-decoration-color: red; text-decoration-thickness: 3px; text-decoration-style: wavy; text-underline-offset: 2px;">${word}</span>`;
                    detectedWordsOnThisPage += 1;
                } else {
                    // Sonst, füge das Wort unverändert hinzu
                    newHTMLContent += word;
                }
            }
            
            // Setze den neuen, bearbeiteten HTML-Inhalt in das Element ein
            tag.innerHTML = newHTMLContent;

            console.log("Element bearbeitet. Neuer Inhalt:", tag.innerHTML);
        }
    }
}

    chrome.storage.sync.set({ 'detectedWords': detectedWordsOnThisPage});      // gezählte Wörter werden gespeichert und später von popup.js aufgerufen
    console.log("erkannte Wörter: ", detectedWordsOnThisPage);
}



chrome.storage.sync.get('checkboxState1', function(data){
    const checkboxState1 = data.checkboxState1 || false;
    if (checkboxState1){
        highlight();
    }
});

chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
    if (request.action === "checkboxStatusChanged") {
        console.log("Checkbox-Status geändert, Seite wird neu geladen...");
        // Lade die Seite neu, um die Änderungen anzuwenden
        window.location.reload();
    }
});
